#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-4655 (bind).

BIND (Berkeley Internet Name Domain) is an implementation of the DNS
(Domain Name System) protocols. BIND includes a DNS server (named),
which resolves host names to IP addresses; a resolver library
(routines for applications to use when interfacing with DNS); and
tools for verifying that the DNS server is operating properly.

-
Update Information:

- bind-chroot-admin called restorecon on /proc filesystem (#405281)
- 9.5.0b1 release (#405281, #392491)
- stop with initscript will fail if rndc was disabled (#417431)
- fixed IDN support in dig and host utilities (#412241)
- added dst/gssapi.h to -devel subpackage (#419091)
- CVE-2007-6283 - /etc/rndc.key file had insecure permissions


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29763);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6283");
 
 name["english"] = "Fedora Core 8 2007-4655: bind";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the bind package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"bind-9.5.0-20.b1.fc8", prefix:"bind-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"bind-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-6283", value:TRUE);
}
