#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-4667 (libexif).

Most digital cameras produce EXIF files, which are JPEG files with
extra tags that contain information about the image. The EXIF library
allows you to parse an EXIF file and read the data from those tags.

-
Update Information:

This update fixes to recently discovered vulnerabilities in libexif, CVE-2007-6
351 and CVE-2007-6352.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29765);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6351", "CVE-2007-6352");
 
 name["english"] = "Fedora Core 8 2007-4667: libexif";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libexif package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"libexif-0.6.15-5.fc8", prefix:"libexif-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"libexif-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-6351", value:TRUE);
 set_kb_item(name:"CVE-2007-6352", value:TRUE);
}
