#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-4690 (wireshark).

Wireshark is a network traffic analyzer for Unix-ish operating systems.

This package lays base for libpcap, a packet capture and filtering
library, contains command-line utilities, contains plugins and
documentation for wireshark. A graphical user interface is packaged
separately to GTK+ package.

-
Update Information:

upgrade to 0.99.7 fixes various security flaws.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29766);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6111", "CVE-2007-6112", "CVE-2007-6113", "CVE-2007-6114", "CVE-2007-6115", "CVE-2007-6116", "CVE-2007-6117", "CVE-2007-6118", "CVE-2007-6119", "CVE-2007-6120", "CVE-2007-6121");
 
 name["english"] = "Fedora Core 7 2007-4690: wireshark";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wireshark package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"wireshark-0.99.7-1.fc7", prefix:"wireshark-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"wireshark-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-6111", value:TRUE);
 set_kb_item(name:"CVE-2007-6112", value:TRUE);
 set_kb_item(name:"CVE-2007-6113", value:TRUE);
 set_kb_item(name:"CVE-2007-6114", value:TRUE);
 set_kb_item(name:"CVE-2007-6115", value:TRUE);
 set_kb_item(name:"CVE-2007-6116", value:TRUE);
 set_kb_item(name:"CVE-2007-6117", value:TRUE);
 set_kb_item(name:"CVE-2007-6118", value:TRUE);
 set_kb_item(name:"CVE-2007-6119", value:TRUE);
 set_kb_item(name:"CVE-2007-6120", value:TRUE);
 set_kb_item(name:"CVE-2007-6121", value:TRUE);
}
