#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-483 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

Update Information:

Linux kernel 2.6.20.7
[8]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.20.7
Previous kernel had most of this update already applied.

Linux kernel 2.6.20.8
[9]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.20.8
Fixes CVE-2007-1861

Linux kernel 2.6.20.9
[10]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.20.9
Fixes CVE-2007-2242

Linux kernel 2.6.20.10
[11]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.20.10
Fixes two bugs introduced by the two previous updates.

CVE-2007-1861:
The netlink protocol has an infinite recursion bug that
allows users to cause a kernel crash.

CVE-2007-2242:
The IPv6 protocol allows remote attackers to cause a denial
of service via crafted IPv6 type 0 route headers
(IPV6_RTHDR_TYPE_0) that create network amplification
between two routers.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25128);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5757", "CVE-2007-0005", "CVE-2007-0006", "CVE-2007-0772", "CVE-2007-1861", "CVE-2007-2242");
 
 name["english"] = "Fedora Core 5 2007-483: kernel";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kernel-2.6.20-1.2316.fc5", prefix:"kernel-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-5757", value:TRUE);
 set_kb_item(name:"CVE-2007-0005", value:TRUE);
 set_kb_item(name:"CVE-2007-0006", value:TRUE);
 set_kb_item(name:"CVE-2007-0772", value:TRUE);
 set_kb_item(name:"CVE-2007-1861", value:TRUE);
 set_kb_item(name:"CVE-2007-2242", value:TRUE);
}
