#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-493 (dovecot).

Dovecot is an IMAP server for Linux/UNIX-like systems, written with security
primarily in mind.  It also contains a small POP3 server.  It supports mail
in either of maildir or mbox formats.



Update information :

* Fri Mar  2 2007 Tomas Janousek <tjanouse redhat com> - 1.0-0.beta8.4.fc5
- a little master login fix (#224925)
- fix for CVE-2007-2231 (#238440)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25183);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-5973", "CVE-2007-2231");
 
 name["english"] = "Fedora Core 5 2007-493: dovecot";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the dovecot package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"dovecot-1.0-0.beta8.4.fc5", prefix:"dovecot-", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"dovecot-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-5973", value:TRUE);
 set_kb_item(name:"CVE-2007-2231", value:TRUE);
}
