#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-526 (php).

PHP is an HTML-embedded scripting language. PHP attempts to make it
easy for developers to write dynamically generated webpages. PHP also
offers built-in database integration for several commercial and
non-commercial database management systems, so writing a
database-enabled webpage with PHP is fairly simple. The most common
use of PHP coding is probably as a replacement for CGI scripts. The
mod_php module enables the Apache Web server to understand and process
the embedded PHP language in Web pages.

Update Information:

This update fixes a number of security issues in PHP.

A heap buffer overflow flaw was found in the PHP 'xmlrpc'
extension. A PHP script which implements an XML-RPC server
using this extension could allow a remote attacker to
execute arbitrary code as the 'apache' user. Note that this
flaw does not affect PHP applications using the pure-PHP
XML_RPC class provided in /usr/share/pear. (CVE-2007-1864)

A flaw was found in the PHP 'ftp' extension. If a PHP script
used this extension to provide access to a private FTP
server, and passed untrusted script input directly to any
function provided by this extension, a remote attacker would
be able to send arbitrary FTP commands to the server.
(CVE-2007-2509)

A buffer overflow flaw was found in the PHP 'soap'
extension, regarding the handling of an HTTP redirect
response when using the SOAP client provided by this
extension with an untrusted SOAP server. No mechanism to
trigger this flaw remotely is known. (CVE-2007-2510)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25302);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2006-4812", "CVE-2006-5465", "CVE-2007-0907", "CVE-2007-0988", "CVE-2007-1001", "CVE-2007-1718", "CVE-2007-1864", "CVE-2007-2509", "CVE-2007-2510");
 
 name["english"] = "Fedora Core 5 2007-526: php";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the php package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"php-xml-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pdo-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-imap-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-xmlrpc-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-bcmath-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-dba-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ncurses-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-devel-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mbstring-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-odbc-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-gd-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-pgsql-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-mysql-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-snmp-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-ldap-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_check( reference:"php-soap-5.1.6-1.6", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"php-", release:"FC5") )
{
 set_kb_item(name:"CVE-2006-4812", value:TRUE);
 set_kb_item(name:"CVE-2006-5465", value:TRUE);
 set_kb_item(name:"CVE-2007-0907", value:TRUE);
 set_kb_item(name:"CVE-2007-0988", value:TRUE);
 set_kb_item(name:"CVE-2007-1001", value:TRUE);
 set_kb_item(name:"CVE-2007-1718", value:TRUE);
 set_kb_item(name:"CVE-2007-1864", value:TRUE);
 set_kb_item(name:"CVE-2007-2509", value:TRUE);
 set_kb_item(name:"CVE-2007-2510", value:TRUE);
}
