#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-612 (perl-Net-DNS).

Net::DNS is a collection of Perl modules that act as a Domain Name
System (DNS) resolver. It allows the programmer to perform DNS queries
that are beyond the capabilities of gethostbyname and gethostbyaddr.

The programmer should be somewhat familiar with the format of a DNS
packet and its various sections. See RFC 1035 or DNS and BIND (Albitz
& Liu) for details.

Update Information:

This brings FC-5 up to date with the latest changes to
Net::DNS. See the project page here:

[8]http://search.cpan.org/~olaf/Net-DNS-0.60/

The change for this upstream issue is included:

[9]http://rt.cpan.org/Public/Bug/Display.html?id=23961

Since this fix has security implications (making DNS
spoofing more difficult), pushing updates to all current
versions of fedora.

Note - I know of no exploits for the security issue
described above.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25658);
 script_version ("$Revision: 1.2 $");
 
 name["english"] = "Fedora Core 5 2007-612: perl-Net-DNS";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the perl-Net-DNS package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"perl-Net-DNS-0.60-1.fc5", release:"FC5") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
