#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-614 (libexif).

Most digital cameras produce EXIF files, which are JPEG files with
extra tags that contain information about the image. The EXIF library
allows you to parse an EXIF file and read the data from those tags.

Update Information:

The libexif package contains the EXIF library. Applications
use this library to parse EXIF image files.

An integer overflow flaw was found in the way libexif parses
EXIF image tags. If a victim opens a carefully crafted EXIF
image file it could cause the application linked against
libexif to execute arbitrary code or crash. (CVE-2007-4168)

Users of libexif should upgrade to these updated packages,
which contain a backported patch and are not vulnerable to
this issue.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25619);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2006-4168");
 
 name["english"] = "Fedora Core 6 2007-614: libexif";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libexif package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"libexif-0.6.15-2.fc6", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"libexif-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-4168", value:TRUE);
}
