#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-655 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

Update Information:

Rebase kernel to 2.6.22.1:
[8]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.22
[9]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.22.1

Includes the CFS scheduler from upstream kernel 2.6.23.

Fixes since initial 2.6.22 test kernel was released:
Fix timer problems and failure to boot.
Fix failure to boot on PS3.
Fix failure to initialize Hpt37x ATA controllers.
Hopefully fix atl1 ethernet controller DMA.
Add RAID autostart (dropped during initial rebase.)
Fix oops in xfrm4, reported on Fedora 7.

CVE-2007-3642:
The decode_choice function in
net/netfilter/bf_conntrack_h323_asn1.c in the Linux kernel
before 2.6.22 allows remote attackers to cause a denial of
service (crash) via an encoded, out-of-range index value for
a choice field, which triggers a NULL pointer dereference.



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25862);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3642");
 
 name["english"] = "Fedora Core 6 2007-655: kernel";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kernel-2.6.22.1-32.fc6", prefix:"kernel-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-3642", value:TRUE);
}
