#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-657 (libgtop2).

libgtop is a library for portably obtaining information about processes,
such as their PID, memory usage, etc.



Update information :

* Thu Aug  2 2007 Soren Sandmann <sandmann redhat com> - 2.14.9-1
- BuildRequire gtk-doc, package documentation files in devel package


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25863);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-0235");
 
 name["english"] = "Fedora Core 6 2007-657: libgtop2";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the libgtop2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"libgtop2-2.14.9-1.fc6", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"libgtop2-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-0235", value:TRUE);
}
