#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-665 (ipsec-tools).

This is the IPsec-Tools package.  You need this package in order to
really use the IPsec functionality in the linux-2.5+ kernels.  This
package builds:

- setkey, a program to directly manipulate policies and SAs
- racoon, an IKEv1 keying daemon



Update information :

* Mon Apr 23 2007 Steve Grubb <sgrubb redhat com> - 0.6.5-8
- Upstream fix for Racoon DOS, informational delete must be encrypted
- Resolves: rhbz#235388 - CVE-2007-1841 ipsec-tools racoon DoS


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25939);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-1841");
 
 name["english"] = "Fedora Core 6 2007-665: ipsec-tools";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ipsec-tools package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"ipsec-tools-0.6.5-8.fc6", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"ipsec-tools-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-1841", value:TRUE);
}
