#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-685 (kdegraphics).

Graphics applications for the K Desktop Environment.

Includes:
kdvi (displays TeX .dvi files)
kghostview (displays postscript files)
kcoloredit (palette editor and color chooser)
kiconedit (icon editor)
kolourpaint (a simple drawing program)
ksnapshot (screen capture utility)
kview (image viewer for GIF, JPEG, TIFF, etc.)
kooka (scanner application)
kruler (screen ruler and color measurement tool)
kpdf (display pdf files)



Update information :

* Wed Aug 29 2007 Than Ngo <than redhat com> - 7:3.5.7-1.fc6.1
- resolves bz#251511, CVE-2007-3387 kpdf integer overflow



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25978);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-3387");
 
 name["english"] = "Fedora Core 6 2007-685: kdegraphics";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kdegraphics package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kdegraphics-3.5.7-1.fc6.1", prefix:"kdegraphics-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kdegraphics-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-3387", value:TRUE);
}
