#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-722 (util-linux).

The util-linux package contains a large variety of low-level system
utilities that are necessary for a Linux system to function. Among
others, Util-linux contains the fdisk configuration tool and the login
program.



Update information :

* Mon Oct  8 2007 Karel Zak <kzak redhat com>  2.13-0.49
- fix #320141 - CVE-2007-5191 util-linux (u)mount doesn't drop privileges prope
rly when calling helpers [FC6]



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27059);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CVE-2007-5191");
 
 name["english"] = "Fedora Core 6 2007-722: util-linux";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the util-linux package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"util-linux-2.13-0.49.fc6", prefix:"util-linux-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"util-linux-", release:"FC6") )
{
 set_kb_item(name:"CVE-2007-5191", value:TRUE);
}
