#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2007-733 (thunderbird).

Mozilla Thunderbird is a standalone mail and newsgroup client.



Update information :

* Thu Oct 18 2007 Martin Stransky <stransky redhat com> - 1.5.0.12-3
- Update to latest snapshot of Mozilla 1.8.0 branch
- added pathes for Mozilla bugs 199088,267833,309322,345305,361745,
362901,372309,378787,381300,384105,386914,387033,387881,388121,388784
390078,393537,395942,325761,392149



Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(27633);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 6 2007-733: thunderbird";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the thunderbird package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"thunderbird-1.5.0.12-3.fc6", prefix:"thunderbird-", release:"FC6") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
