#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-0103 (wordpress).

Wordpress is an online publishing / weblog package that makes it very easy,
almost trivial, to get information out to people on the web.

-
Update Information:

This closes:

[9]http://www.blackhatdomainer.com/how-to-know-today-what-shoemoney-is-going-to
-post-tomorrow/

[10]http://www.securityfocus.com/archive/1/485252/30/0/threaded

[11]http://trac.wordpress.org/ticket/5487


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29843);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6318");
 
 name["english"] = "Fedora Core 8 2008-0103: wordpress";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wordpress package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"wordpress-2.3.2-1.fc8", prefix:"wordpress-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"wordpress-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-6318", value:TRUE);
}
