#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-0282 (mantis).

Mantis is a web-based bugtracking system.
It is written in the PHP scripting language and requires the MySQL
database and a webserver. Mantis has been installed on Windows, MacOS,
OS/2, and a variety of Unix operating systems. Any web browser should
be able to function as a client.

Documentation can be found in: /usr/share/doc/mantis-1.1.0

When the package has finished installing, you will need to perform some
additional configuration steps; these are described in:
/usr/share/doc/mantis-1.1.0/README.Fedora

-
Update Information:

Please note this is a major mantis release, and a upgrade to the DB schema is n
eeded.

Please refer to the package documentation to complete the upgrade.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(29862);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6611");
 
 name["english"] = "Fedora Core 7 2008-0282: mantis";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mantis package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"mantis-1.1.0-1.fc7", prefix:"mantis-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"mantis-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-6611", value:TRUE);
}
