#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-0880 (boost).

Boost provides free peer-reviewed portable C++ source libraries.  The
emphasis is on libraries which work well with the C++ Standard
Library, in the hopes of establishing 'existing practice' for
extensions and providing reference implementations so that the Boost
libraries are suitable for eventual standardization. (Some of the
libraries have already been proposed for inclusion in the C++
Standards Committee's upcoming C++ Standard Library Technical Report.)

-
ChangeLog:


Update information :

* Wed Jan 16 2008 Petr Machata <pmachata redhat com> - 1.33.1-15
- Fixes for boost.regex.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30078);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0171", "CVE-2008-0172");
 
 name["english"] = "Fedora Core 7 2008-0880: boost";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the boost package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"boost-1.33.1-15.fc7", prefix:"boost-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"boost-", release:"FC7") )
{
 set_kb_item(name:"CVE-2008-0171", value:TRUE);
 set_kb_item(name:"CVE-2008-0172", value:TRUE);
}
