#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-0956 (xorg-x11-server).

X.Org X11 X server

-
Update Information:

When enabling the 'unredirect fullscreen windows' option, compiz will unredirec
t fullscreen windows to improve performace.  However, unredirecting will as a s
ide effect break any grabs on that window, which compromises most screensavers.
This X server update suppresses this unintended side effect and restores the
security of the screensavers.  See also CVE-2007-3069.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30083);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-3069", "CVE-2007-3920");
 
 name["english"] = "Fedora Core 7 2008-0956: xorg-x11-server";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xorg-x11-server package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"xorg-x11-server-1.3.0.0-16.fc7", prefix:"xorg-x11-server-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"xorg-x11-server-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-3069", value:TRUE);
 set_kb_item(name:"CVE-2007-3920", value:TRUE);
}
