#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-0958 (kernel).

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

-
Update Information:

Update to Linux kernel 2.6.23.14:
[8]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.23.13
[9]http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.23.14
CVE-2008-0001:  VFS in the Linux kernel before 2.6.22.16, and 2.6.23.x before
2.6.23.14, performs tests of access mode by using the flag variable instead of
the acc_mode variable, which might allow local users to bypass intended
permissions and remove directories.    Plus:  Major wireless driver updates.
Restored the /proc/slabinfo file.  Additional bug fixes for the listed Bugzilla
entries.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30113);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5938", "CVE-2008-0001");
 
 name["english"] = "Fedora Core 8 2008-0958: kernel";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kernel-2.6.23.14-64.fc7", prefix:"kernel-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"kernel-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-5938", value:TRUE);
 set_kb_item(name:"CVE-2008-0001", value:TRUE);
}
