#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1036 (icu).

Tools and utilities for developing with icu.

-
Update Information:

CVE-2007-4770 & CVE-2007-4771    Flaws in icu regexp handling.     Technical
details can be found at [9]http://sourceforge.net/mailarchive/message.php?msg_n
ame=
d03a2ffb0801221538x68825e42xb4a4aaf0fcccecbd%2540mail.gmail.com


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30086);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-4771");
 
 name["english"] = "Fedora Core 8 2008-1036: icu";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the icu package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"icu-3.8-5.fc8", prefix:"icu-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"icu-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-4771", value:TRUE);
}
