#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1122 (tk).

When paired with the Tcl scripting language, Tk provides a fast and powerful
way to create cross-platform GUI applications.

-
Update Information:

The new version of tk, which brings some bug fixes f.e. better functionality on
64bits.    Fixed security issue - buffer overflow in gif parsing.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30234);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-4484", "CVE-2008-0553");
 
 name["english"] = "Fedora Core 8 2008-1122: tk";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tk package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"tk-8.4.17-2.fc8", prefix:"tk-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"tk-", release:"FC8") )
{
 set_kb_item(name:"CVE-2006-4484", value:TRUE);
 set_kb_item(name:"CVE-2008-0553", value:TRUE);
}
