#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1459 (seamonkey).

SeaMonkey is an all-in-one Internet application suite. It includes
a browser, mail/news client, IRC client, JavaScript debugger, and
a tool to inspect the DOM for web pages. It is derived from the
application formerly known as Mozilla Application Suite.

-
ChangeLog:


Update information :

* Fri Feb  8 2008 Kai Engert <kengert redhat com> - 1.1.8-1
- SeaMonkey 1.1.8


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31061);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0414", "CVE-2008-0415", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0592", "CVE-2008-0593");
 
 name["english"] = "Fedora Core 8 2008-1459: seamonkey";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the seamonkey package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"seamonkey-1.1.8-1.fc8", prefix:"seamonkey-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"seamonkey-", release:"FC8") )
{
 set_kb_item(name:"CVE-2008-0412", value:TRUE);
 set_kb_item(name:"CVE-2008-0413", value:TRUE);
 set_kb_item(name:"CVE-2008-0414", value:TRUE);
 set_kb_item(name:"CVE-2008-0415", value:TRUE);
 set_kb_item(name:"CVE-2008-0417", value:TRUE);
 set_kb_item(name:"CVE-2008-0418", value:TRUE);
 set_kb_item(name:"CVE-2008-0419", value:TRUE);
 set_kb_item(name:"CVE-2008-0591", value:TRUE);
 set_kb_item(name:"CVE-2008-0592", value:TRUE);
 set_kb_item(name:"CVE-2008-0593", value:TRUE);
}
