#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1535 (ruby-gnome2).

This is a set of bindings for the GNOME-2.x libraries for use from Ruby.

-
Update Information:

Mozilla Firefox is an open source Web browser.    Several flaws were found in
the way Firefox processed certain malformed web content. A webpage containing
malicious content could cause Firefox to crash, or potentially execute arbitrar
y
code as the user running Firefox. (CVE-2008-0412, CVE-2008-0413, CVE-2008-0415,
CVE-2008-0419)    Several flaws were found in the way Firefox displayed
malformed web content. A webpage containing specially-crafted content could
trick a user into surrendering sensitive information. (CVE-2008-0591,
CVE-2008-0593)    A flaw was found in the way Firefox stored password data. If
a
user saves login information for a malicious website, it could be possible to
corrupt the password database, preventing the user from properly accessing save
d
password data. (CVE-2008-0417)    A flaw was found in the way Firefox handles
certain chrome URLs. If a user has certain extensions installed, it could allow
a malicious website to steal sensitive session data. Note: this flaw does not
affect a default installation of Firefox. (CVE-2008-0418)    A flaw was found i
n
the way Firefox saves certain text files. If a website offers a file of type
'plain/text', rather than 'text/plain', Firefox will not show future
'text/plain' content to the user in the browser, forcing them to save those
files locally to view the content. (CVE-2008-0592)     Users of firefox are
advised to upgrade to these updated packages, which contain updated packages to
resolve these issues.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31067);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-6183", "CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0414", "CVE-2008-0415", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0592", "CVE-2008-0593", "CVE-2008-0594");
 
 name["english"] = "Fedora Core 8 2008-1535: ruby-gnome2";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ruby-gnome2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"ruby-gnome2-0.16.0-20.fc8", prefix:"ruby-gnome2-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"ruby-gnome2-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-6183", value:TRUE);
 set_kb_item(name:"CVE-2008-0412", value:TRUE);
 set_kb_item(name:"CVE-2008-0413", value:TRUE);
 set_kb_item(name:"CVE-2008-0414", value:TRUE);
 set_kb_item(name:"CVE-2008-0415", value:TRUE);
 set_kb_item(name:"CVE-2008-0417", value:TRUE);
 set_kb_item(name:"CVE-2008-0418", value:TRUE);
 set_kb_item(name:"CVE-2008-0419", value:TRUE);
 set_kb_item(name:"CVE-2008-0591", value:TRUE);
 set_kb_item(name:"CVE-2008-0592", value:TRUE);
 set_kb_item(name:"CVE-2008-0593", value:TRUE);
 set_kb_item(name:"CVE-2008-0594", value:TRUE);
}
