#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1584 (duplicity).

Duplicity incrementally backs up files and directory by encrypting
tar-format volumes with GnuPG and uploading them to a remote (or
local) file server. In theory many protocols for connecting to a
file server could be supported; so far ssh/scp, local file access,
rsync, ftp, HSI, WebDAV and Amazon S3 have been written.

Because duplicity uses librsync, the incremental archives are space
efficient and only record the parts of files that have changed since
the last backup. Currently duplicity supports deleted files, full
unix permissions, directories, symbolic links, fifos, device files,
but not hard links.

-
Update Information:

WARNING: Command line syntax incompatibility!    See e.g.
[9]https://www.redhat.com/archives/epel-devel-list/2008-February/msg00056.html
for
furhter information.     - Upgrade to 0.4.9  - Duplicity discloses password in
FTP backend (CVE-2007-5201)  - Several bug and problem fixes


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31073);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-5201");
 
 name["english"] = "Fedora Core 7 2008-1584: duplicity";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the duplicity package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"duplicity-0.4.9-1.fc7", prefix:"duplicity-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"duplicity-", release:"FC7") )
{
 set_kb_item(name:"CVE-2007-5201", value:TRUE);
}
