#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1603 (tomcat5).

Tomcat is the servlet container that is used in the official Reference
Implementation for the Java Servlet and JavaServer Pages technologies.
The Java Servlet and JavaServer Pages specifications are developed by
Sun under the Java Community Process.

Tomcat is developed in an open and participatory environment and
released under the Apache Software License. Tomcat is intended to be
a collaboration of the best-of-breed developers from around the world.
We invite you to participate in this open development project. To
learn more about getting involved, click here.

-
ChangeLog:


Update information :

* Tue Feb 12 2008 Devrim GUNDUZ <devrim commandprompt com> 0:5.5.26-1jpp.2
- Rebuilt


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31074);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2007-1355", "CVE-2007-1358", "CVE-2007-2449", "CVE-2007-2450", "CVE-2007-3382", "CVE-2007-3385", "CVE-2007-3386", "CVE-2007-5333", "CVE-2007-5342", "CVE-2007-5461", "CVE-2007-6286", "CVE-2008-0002");
 
 name["english"] = "Fedora Core 8 2008-1603: tomcat5";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tomcat5 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"tomcat5-5.5.26-1jpp.2.fc8", prefix:"tomcat5-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"tomcat5-", release:"FC8") )
{
 set_kb_item(name:"CVE-2007-1355", value:TRUE);
 set_kb_item(name:"CVE-2007-1358", value:TRUE);
 set_kb_item(name:"CVE-2007-2449", value:TRUE);
 set_kb_item(name:"CVE-2007-2450", value:TRUE);
 set_kb_item(name:"CVE-2007-3382", value:TRUE);
 set_kb_item(name:"CVE-2007-3385", value:TRUE);
 set_kb_item(name:"CVE-2007-3386", value:TRUE);
 set_kb_item(name:"CVE-2007-5333", value:TRUE);
 set_kb_item(name:"CVE-2007-5342", value:TRUE);
 set_kb_item(name:"CVE-2007-5461", value:TRUE);
 set_kb_item(name:"CVE-2007-6286", value:TRUE);
 set_kb_item(name:"CVE-2008-0002", value:TRUE);
}
