#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1711 (httpd).

The Apache HTTP Server is a powerful, efficient, and extensible
web server.

-
Update Information:

Notes:  This update includes the latest release of httpd 2.2, which fixes a
number of minor security issues and other bugs.    A flaw was found in the
mod_imagemap module. On sites where mod_imagemap was enabled and an imagemap
file was publicly available, a cross-site scripting attack was possible.
(CVE-2007-5000)    A flaw was found in the mod_status module. On sites where
mod_status was enabled and the status pages were publicly accessible, a cross-
site scripting attack was possible. (CVE-2007-6388)    A flaw was found in the
mod_proxy_balancer module. On sites where mod_proxy_balancer was enabled, a
cross-site scripting attack against an authorized user was possible.
(CVE-2007-6421)    A flaw was found in the mod_proxy_balancer module. On sites
where mod_proxy_balancer was enabled, an authorized user could send a carefully
crafted request that would cause the Apache child process handling that request
to crash. This could lead to a denial of service if using a threaded Multi-
Processing Module. (CVE-2007-6422)    A flaw was found in the mod_proxy_ftp
module. On sites where mod_proxy_ftp was enabled and a forward proxy was
configured, a   cross-site scripting attack was possible against browsers which
do not correctly derive the response character set following the rules in RFC
2616. (CVE-2008-0005)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31105);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2006-5752", "CVE-2007-1862", "CVE-2007-3304", "CVE-2007-5000", "CVE-2007-6388", "CVE-2007-6421", "CVE-2007-6422", "CVE-2008-0005");
 
 name["english"] = "Fedora Core 7 2008-1711: httpd";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the httpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"httpd-2.2.8-1.fc7", prefix:"httpd-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"httpd-", release:"FC7") )
{
 set_kb_item(name:"CVE-2006-5752", value:TRUE);
 set_kb_item(name:"CVE-2007-1862", value:TRUE);
 set_kb_item(name:"CVE-2007-3304", value:TRUE);
 set_kb_item(name:"CVE-2007-5000", value:TRUE);
 set_kb_item(name:"CVE-2007-6388", value:TRUE);
 set_kb_item(name:"CVE-2007-6421", value:TRUE);
 set_kb_item(name:"CVE-2007-6422", value:TRUE);
 set_kb_item(name:"CVE-2008-0005", value:TRUE);
}
