#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1771 (dnssec-tools).


The goal of the DNSSEC-Tools project is to create a set of tools,
patches, applications, wrappers, extensions, and plugins that will
help ease the deployment of DNSSEC-related technologies.

-
Update Information:

1.3.2 release which contains a small set of fixes over the 1.3 release.  The
biggest of these fixes is a patch to the libval DNSSEC validation library to
ensure that the signature that validates it is a signature of the trust anchor
itself.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31172);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 8 2008-1771: dnssec-tools";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the dnssec-tools package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"dnssec-tools-1.3.2-1.fc8", prefix:"dnssec-tools-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
