#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1783 (pcre).

Perl-compatible regular expression library.
PCRE has its own native API, but a set of 'wrapper' functions that are based on
the POSIX API are also supplied in the library libpcreposix. Note that this
just provides a POSIX calling interface to PCRE: the regular expressions
themselves still follow Perl syntax and semantics. The header file
for the POSIX-style functions is called pcreposix.h.

-
Update Information:

This update addresses buffer overflow caused by a character class containing a
very large number of characters with codepoints greater than 255 (in UTF-8 mode
)
- CVE-2008-0674, #431660    This issue may affect usages of pcre, when regular
expressions from untrusted sources are compiled.  Handling of untrusted data
using trusted regular expressions is not affected by this problem.


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31124);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0674");
 
 name["english"] = "Fedora Core 8 2008-1783: pcre";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pcre package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"pcre-7.3-3.fc8", prefix:"pcre-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"pcre-", release:"FC8") )
{
 set_kb_item(name:"CVE-2008-0674", value:TRUE);
}
