#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1905 (moin).

A WikiWikiWeb is a collaborative hypertext environment, with an emphasis on
easy access to and modification of information. MoinMoin is a Python
WikiClone that allows you to easily set up your own wiki, only requiring a
Web server and a Python installation.

-
ChangeLog:


Update information :

* Wed Feb 20 2008 Lubomir Kundrak <lkundrak redhat com> 1.5.8-4
- Fix CVE-2008-0780 XSS in login action (2f952fa361c7)
- Fix CVE-2008-0781 multiple XSS in AttachFile action (db212dfc58ef)


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31153);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0780", "CVE-2008-0781");
 
 name["english"] = "Fedora Core 8 2008-1905: moin";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the moin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"moin-1.5.8-4.fc8", prefix:"moin-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"moin-", release:"FC8") )
{
 set_kb_item(name:"CVE-2008-0780", value:TRUE);
 set_kb_item(name:"CVE-2008-0781", value:TRUE);
}
