#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1963 (wyrd).

wyrd is a ncurses frontend for the calendar application remind.

-
References:

[ 1 ] Bug #433719 - CVE-2008-0806 Wyrd uses insecure temporary file
[9]https://bugzilla.redhat.com/show_bug.cgi?id=433719


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31176);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CVE-2008-0806");
 
 name["english"] = "Fedora Core 7 2008-1963: wyrd";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wyrd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"wyrd-1.4.3b-1.fc7", prefix:"wyrd-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
if ( rpm_exists(rpm:"wyrd-", release:"FC7") )
{
 set_kb_item(name:"CVE-2008-0806", value:TRUE);
}
