#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1973 (kvm).

KVM (for Kernel-based Virtual Machine) is a full virtualization solution
for Linux on x86 hardware.

Using KVM, one can run multiple virtual machines running unmodified Linux
or Windows images. Each virtual machine has private virtualized hardware:
a network card, disk, graphics adapter, etc.

-
Update Information:

Ian Jackson discovered that accesses beyond end of qemu emulated disk devices
can result in accesses to emulator's virtual memory space accesses and thus can
allow user with sufficient privilege in guest (root, as this would need
modification to kernel's driver) to break out of VM.    [9]http://marc.info/?l
=debian-security&m=120343592917055&w=2


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31177);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 7 2008-1973: kvm";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kvm package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"kvm-36-8.fc7", prefix:"kvm-", release:"FC7") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
