#
# (C) Tenable Network Security
#
# This plugin text is was extracted from the Fedora Security Advisory
#

 desc["english"] = "
The remote host is missing the patch for the advisory FEDORA-2008-1995 (qemu).

QEMU is a generic and open source processor emulator which achieves a good
emulation speed by using dynamic translation. QEMU has two operating modes:

* Full system emulation. In this mode, QEMU emulates a full system (for
example a PC), including a processor and various peripherials. It can be
used to launch different Operating Systems without rebooting the PC or
to debug system code.
* User mode emulation. In this mode, QEMU can launch Linux processes compiled
for one CPU on another CPU.

As QEMU requires no host kernel patches to run, it is safe and easy to use.

-
Update Information:

Ian Jackson discovered that accesses beyond end of qemu emulated disk devices
can result in accesses to emulator's virtual memory space accesses and thus can
allow user with sufficient privilege in guest (root, as this would need
modification to kernel's driver) to break out of VM.    [9]http://marc.info/?l
=debian-security&m=120343592917055&w=2


Solution : Get the newest Fedora Updates
Risk factor : High";

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(31181);
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "Fedora Core 8 2008-1995: qemu";
 
 script_name(english:name["english"]);
 



 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the qemu package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check( reference:"qemu-0.9.0-6.fc8", prefix:"qemu-", release:"FC8") )
{
 security_hole(port:0, extra:rpm_report_get());
 exit(0);
}
