#
# (C) Tenable Network Security
#

 desc["english"] = "
Synopsis :

It is possible to obtain information about the remote host. 

Description :

The remote host is running the 'finger' service. 

The purpose of this service is to show who is currently logged into
the remote system, and to give information about the users of the
remote system. 
 
It provides useful information to attackers, since it allows them to
gain usernames, determine how used a machine is, and see when each
user logged in for the last time. 

Solution :  

Comment out the 'finger' line in /etc/inetd.conf and restart the 
inetd process

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if(description)
{
 script_id(10068);
 script_version ("$Revision: 1.28 $");
 script_cve_id("CVE-1999-0612");
 script_xref(name:"OSVDB", value:"11451");
 name["english"] = "Finger";
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 summary["english"] = "Checks for finger";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "Useless services";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl");
 script_require_ports("Services/finger", 79);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/finger");
if(!port)port = 79;
if(get_port_state(port))
{
 soc = open_sock_tcp(port);
 if(soc)
 {
  buf = string("root\r\n");
  send(socket:soc, data:buf);
  data = recv(socket:soc, length:65535);
  if(egrep(pattern:".*User|[lL]ogin|logged.*", string:data))
  {
   report = "
The 'finger' service provides useful information to attackers, since it allows 
them to gain usernames, check if a machine is being used, and so on... 

Here is the output we obtained for 'root' : " + string("\n\n", data, "\n\n");

   report = string (
		desc["english"],
		"\n\nPlugin output :\n\n",
		report
		);

   security_warning(port:port, data:report);
   set_kb_item(name:"finger/active", value:TRUE);
  }

  close(soc);
 }
}
