#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote Windows host contains a browser plugin that is affected by
several critical flaws. 

Description :

According to its version number, the instance of Flash Player on the
remote Windows host contains multiple critical and as-yet unspecified
vulnerabilities that could allow an attacker to take control of the
affected host.  To exploit these issues, a user must load a malicious
SWF file in Flash Player. 

See also :

http://www.microsoft.com/technet/security/Bulletin/MS06-020.mspx
http://www.microsoft.com/technet/security/advisory/916208.mspx
http://www.macromedia.com/devnet/security/security_zone/apsb06-03.html

Solution :

Upgrade to Flash Player version 8.0.24.0 / 7.0.63.0 or later. 

Risk factor :

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(21079);
  script_version("$Revision: 1.9 $");

  script_cve_id("CVE-2006-0024");
  script_bugtraq_id(17106);
  script_xref(name:"OSVDB", value:"23908");

  script_name(english:"Flash Player APSB06-03");
  script_summary(english:"Checks version of Flash Player");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("flash_player_installed.nasl");
  script_require_keys("SMB/Flash_Player/installed");

  exit(0);
}


if (!get_kb_item("SMB/Flash_Player/installed")) exit(0);


# Identify vulnerable versions.
info = "";

foreach variant (make_list("Plugin", "ActiveX"))
{
  vers = get_kb_list("SMB/Flash_Player/"+variant+"/Version/*");
  files = get_kb_list("SMB/Flash_Player/"+variant+"/File/*");
  if (!isnull(vers) && !isnull(files))
  {
    foreach key (keys(vers))
    {
      num = key - ("SMB/Flash_Player/"+variant+"/Version/");

      ver = vers[key];
      if (ver)
      {
        iver = split(ver, sep:'.', keep:FALSE);
        for (i=0; i<max_index(iver); i++)
          iver[i] = int(iver[i]);

        if (
          iver[0] < 6 ||
          (iver[0] == 6 && iver[1] == 0 && iver[2] < 84) ||
          (iver[0] == 7 && iver[1] == 0 && iver[2] < 63) ||
          (iver[0] == 8 && iver[1] == 0 && iver[2] < 24)
        )
        {
          file = files["SMB/Flash_Player/"+variant+"/File/"+num];
          if (variant == "Plugin")
          {
            info += '  - Browser Plugin (for Firefox / Netscape / Opera) :\n';
          }
          else if (variant == "ActiveX")
          {
            info += '  - ActiveX control (for Internet Explorer) :\n';
          }
          info += '    ' + file + ', ' + ver + '\n';
        }
      }
    }
  }
}


if (info)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus has identified the following vulnerable instance(s) of Flash\n",
    "Player installed on the remote host :\n",
    "\n",
    info
  );
  security_warning(port:get_kb_item("SMB/transport"), data:report);
}
