#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote Windows host contains a browser plugin that is affected by
multiple HTTP header injection issues. 

Description :

According to its version number, the instance of Flash Player on the
remote Windows host contains two ways for a remote attacker to perform
arbitrary HTTP requests while controlling most of the HTTP headers.  A
remote attacker may be able to leverage these issues to conduct
cross-site request forgery attacks against a user who visits a
malicious web site. 

See also :

http://www.rapid7.com/advisories/R7-0026.jsp
http://www.adobe.com/support/security/bulletins/apsb06-18.html

Solution :

Upgrade to Flash Player version 9.0.28.0 / 8.0.34.0 / 7.0.67.0 or
later. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:P/A:N)";


if (description)
{
  script_id(23869);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2006-5330");
  script_bugtraq_id(20592, 20593);
  script_xref(name:"OSVDB", value:"29863");

  script_name(english:"Flash Player APSB06-18");
  script_summary(english:"Checks version of Flash Player");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("flash_player_installed.nasl");
  script_require_keys("SMB/Flash_Player/installed");

  exit(0);
}


if (!get_kb_item("SMB/Flash_Player/installed")) exit(0);


# Identify vulnerable versions.
info = "";

foreach variant (make_list("Plugin", "ActiveX"))
{
  vers = get_kb_list("SMB/Flash_Player/"+variant+"/Version/*");
  files = get_kb_list("SMB/Flash_Player/"+variant+"/File/*");
  if (!isnull(vers) && !isnull(files))
  {
    foreach key (keys(vers))
    {
      num = key - ("SMB/Flash_Player/"+variant+"/Version/");

      ver = vers[key];
      if (ver)
      {
        iver = split(ver, sep:'.', keep:FALSE);
        for (i=0; i<max_index(iver); i++)
          iver[i] = int(iver[i]);

        if (
          (iver[0] == 7 && iver[1] == 0 && iver[2] < 67) ||
          (iver[0] == 8 && iver[1] == 0 && iver[2] < 34) ||
          (iver[0] == 9 && iver[1] == 0 && iver[2] < 28)
        )
        {
          file = files["SMB/Flash_Player/"+variant+"/File/"+num];
          if (variant == "Plugin")
          {
            info += '  - Browser Plugin (for Firefox / Netscape / Opera) :\n';
          }
          else if (variant == "ActiveX")
          {
            info += '  - ActiveX control (for Internet Explorer) :\n';
          }
          info += '    ' + file + ', ' + ver + '\n';
        }
      }
    }
  }
}


if (info)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus has identified the following vulnerable instance(s) of Flash\n",
    "Player installed on the remote host :\n",
    "\n",
    info
  );
  security_warning(port:get_kb_item("SMB/transport"), data:report);
}
