#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote Windows host contains a browser plugin that is affected by
multiple issues. 

Description :

According to its version number, the instance of Flash Player on the
remote Windows host could allow for arbitrary code execution by means
of a malicious SWF file. 

In addition, it may also fail to sufficiently validate the HTTP
Referer header, which may aid in cross-site request forgery attacks. 
This issue does not, though, affect Flash Player 9. 

See also :

http://www.adobe.com/support/security/bulletins/apsb07-12.html

Solution :

Upgrade to Flash Player version 9.0.47.0 / 8.0.35.0 / 7.0.70.0 or
later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(25694);
  script_version("$Revision: 1.8 $");

  script_cve_id("CVE-2007-3456", "CVE-2007-3457");
  script_bugtraq_id(24856);
  script_xref(name:"OSVDB", value:"38049");
  script_xref(name:"OSVDB", value:"38054");

  script_name(english:"Flash Player APSB07-12");
  script_summary(english:"Checks version of Flash Player");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("flash_player_installed.nasl");
  script_require_keys("SMB/Flash_Player/installed");

  exit(0);
}


if (!get_kb_item("SMB/Flash_Player/installed")) exit(0);


# Identify vulnerable versions.
info = "";

foreach variant (make_list("Plugin", "ActiveX"))
{
  vers = get_kb_list("SMB/Flash_Player/"+variant+"/Version/*");
  files = get_kb_list("SMB/Flash_Player/"+variant+"/File/*");
  if (!isnull(vers) && !isnull(files))
  {
    foreach key (keys(vers))
    {
      num = key - ("SMB/Flash_Player/"+variant+"/Version/");

      ver = vers[key];
      if (ver)
      {
        iver = split(ver, sep:'.', keep:FALSE);
        for (i=0; i<max_index(iver); i++)
          iver[i] = int(iver[i]);

        if (
          (iver[0] == 7 && iver[1] == 0 && iver[2] < 70) ||
          (iver[0] == 8 && iver[1] == 0 && iver[2] < 35) ||
          (iver[0] == 9 && iver[1] == 0 && iver[2] < 47)
        )
        {
          file = files["SMB/Flash_Player/"+variant+"/File/"+num];
          if (variant == "Plugin")
          {
            info += '  - Browser Plugin (for Firefox / Netscape / Opera) :\n';
          }
          else if (variant == "ActiveX")
          {
            info += '  - ActiveX control (for Internet Explorer) :\n';
          }
          info += '    ' + file + ', ' + ver + '\n';
        }
      }
    }
  }
}


if (info)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus has identified the following vulnerable instance(s) of Flash\n",
    "Player installed on the remote host :\n",
    "\n",
    info
  );
  security_hole(port:get_kb_item("SMB/transport"), data:report);
}
