#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote host contains an application that is affected by remote
code execution flaws. 

Description :

According to its version number, the instance of Macromedia's Flash
Player on the remote host fails to validate the frame type identifier
from SWF files before using that as an index into an array of function
pointers.  An attacker may be able to leverage this issue using a
specially-crafted SWF file to execute arbitrary code on the remote
host subject to the permissions of the user running Flash Player. 

See also :

http://research.eeye.com/html/advisories/published/AD20051104.html
http://www.sec-consult.com/228.html
http://www.macromedia.com/devnet/security/security_zone/mpsb05-07.html

Solution :

Upgrade to Flash Player version 8.0.22.0 / 7.0.60.0 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description) {
  script_id(20158);
  script_version("$Revision: 1.12 $");

  script_cve_id("CVE-2005-2628", "CVE-2005-3591");
  script_bugtraq_id(15332, 15334);
  script_xref(name:"OSVDB", value:"18825");

  script_name(english:"Flash Player Improper Memory Access Vulnerabilities");
  script_summary(english:"Checks version of Flash Player");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");

  script_dependencies("flash_player_installed.nasl");
  script_require_keys("SMB/Flash_Player/installed");

  exit(0);
}


if (!get_kb_item("SMB/Flash_Player/installed")) exit(0);


# Identify vulnerable versions.
info = "";

foreach variant (make_list("Plugin", "ActiveX"))
{
  vers = get_kb_list("SMB/Flash_Player/"+variant+"/Version/*");
  files = get_kb_list("SMB/Flash_Player/"+variant+"/File/*");
  if (!isnull(vers) && !isnull(files))
  {
    foreach key (keys(vers))
    {
      num = key - ("SMB/Flash_Player/"+variant+"/Version/");

      ver = vers[key];
      if (ver)
      {
        iver = split(ver, sep:'.', keep:FALSE);
        for (i=0; i<max_index(iver); i++)
          iver[i] = int(iver[i]);

        if (
          iver[0] < 6 ||
          (iver[0] == 7 && iver[1] == 0 && iver[2] <= 53)
        )
        {
          file = files["SMB/Flash_Player/"+variant+"/File/"+num];
          if (variant == "Plugin")
          {
            info += '  - Browser Plugin (for Firefox / Netscape / Opera) :\n';
          }
          else if (variant == "ActiveX")
          {
            info += '  - ActiveX control (for Internet Explorer) :\n';
          }
          info += '    ' + file + ', ' + ver + '\n';
        }
      }
    }
  }
}


if (info)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus has identified the following vulnerable instance(s) of Flash\n",
    "Player installed on the remote host :\n",
    "\n",
    info
  );
  security_hole(port:get_kb_item("SMB/transport"), data:report);
}
