#
# (C) Tenable Network Security
#
#

if(description)
{
 script_id(11810);
 script_bugtraq_id(8288);
 script_version ("$Revision: 1.15 $");
 script_cve_id("CVE-2003-0614");
 script_xref(name:"OSVDB", value:"2322");
 name["english"] = "gallery xss";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server contains a PHP script that is prone to a cross-
site scripting attack. 

Description :

The remote host is running the Gallery web-based photo album. 

There is a flaw in the version of Gallery installed on the remote host
that makes it vulnerable to a cross-site scripting attack due to a
failure to properly sanitize input to the 'searchstring' parameter of
the 'search.php' script.  A remote attacker may use this to steal the
cookies from the legitimate users of this system. 

See also :

http://gallery.menalto.com/node/82

Solution : 

Upgrade to Gallery 1.3.4p1 or later.

Risk factor : 

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of search.php";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2003-2007 Tenable Network Security");
 
 family["english"] = "CGI abuses : XSS";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "http_version.nasl", "cross_site_scripting.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);


if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);
if(get_kb_item(string("www/", port, "/generic_xss"))) exit(0);

function check(url)
{
  local_var r, req;
  global_var port;

  req = http_get(item:string(url, "/search.php?searchstring=<script>foo</script>"),
		port:port);
  r = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
  if ( r == NULL ) exit(0);
  if("<script>foo</script>" >< r && "<!-- search.header begin -->" >< r)
 	{
 	security_warning(port);
	exit(0);
	}
 
}

foreach dir (cgi_dirs())
{
 check(url:dir);
}
