# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200610-13.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(22928);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200610-13");
 script_cve_id("CVE-2006-3814");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200610-13
(Cheese Tracker: Buffer Overflow)


    Luigi Auriemma reported that the XM loader of Cheese Tracker contains a
    buffer overflow vulnerability in the
    loader_XM::load_intrument_internal() function from
    loaders/loader_xm.cpp.
  
Impact

    An attacker could execute arbitrary code with the rights of the user
    running Cheese Tracker by enticing a user to load a crafted file with
    large amount of extra data.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-3814


Solution: 
    All Cheese Tracker users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-sound/cheesetracker-0.9.9-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200610-13] Cheese Tracker: Buffer Overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Cheese Tracker: Buffer Overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-sound/cheesetracker", unaffected: make_list("ge 0.9.9-r1"), vulnerable: make_list("lt 0.9.9-r1")
)) { security_warning(0); exit(0); }
