# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-14.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23708);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-14");
 script_cve_id("CVE-2006-5677");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-14
(TORQUE: Insecure temproary file creation)


    TORQUE creates temporary files with predictable names. Please note that
    the TORQUE package shipped in Gentoo Portage is not vulnerable in the
    default configuration. Only systems with more permissive access rights
    to the spool directory are vulnerable.
  
Impact

    A local attacker could create links in the temporary file directory,
    pointing to a valid file somewhere on the filesystem. This could lead
    to the execution of arbitrary code with elevated privileges.
  
Workaround

    Ensure that untrusted users don\'t have write access to the spool
    directory.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5677


Solution: 
    All TORQUE users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=sys-cluster/torque-2.1.2-r2"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-14] TORQUE: Insecure temproary file creation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'TORQUE: Insecure temproary file creation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "sys-cluster/torque", unaffected: make_list("ge 2.1.2-r2"), vulnerable: make_list("lt 2.1.2-r2")
)) { security_hole(0); exit(0); }
