# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-20.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23728);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-20");
 script_cve_id("CVE-2006-5864");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-20
(GNU gv: Stack overflow)


    GNU gv does not properly boundary check user-supplied data before
    copying it into process buffers.
  
Impact

    An attacker could entice a user to open a specially crafted document
    with GNU gv and execute arbitrary code with the rights of the user on
    the system.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5864


Solution: 
    All gv users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-text/gv-3.6.2-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-20] GNU gv: Stack overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'GNU gv: Stack overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-text/gv", unaffected: make_list("ge 3.6.2-r1"), vulnerable: make_list("lt 3.6.2-r1")
)) { security_warning(0); exit(0); }
