# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-22.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23730);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-22");
 script_cve_id("CVE-2006-5449");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-22
(Ingo H3: Folder name shell command injection)


    Ingo H3 fails to properly escape shell metacharacters in procmail
    rules.
  
Impact

    A remote authenticated attacker could craft a malicious rule which
    could lead to the execution of arbitrary shell commands on the server.
  
Workaround

    Don\'t use procmail with Ingo H3.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5449


Solution: 
    All Ingo H3 users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/horde-ingo-1.1.2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-22] Ingo H3: Folder name shell command injection");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Ingo H3: Folder name shell command injection');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/horde-ingo", unaffected: make_list("ge 1.1.2"), vulnerable: make_list("lt 1.1.2")
)) { security_warning(0); exit(0); }
