# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-23.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23745);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-23");
 script_cve_id("CVE-2006-5072");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-23
(Mono: Insecure temporary file creation)


    Sebastian Krahmer of the SuSE Security Team discovered that the
    System.CodeDom.Compiler classes of Mono create temporary files with
    insecure permissions.
  
Impact

    A local attacker could create links in the temporary file directory,
    pointing to a valid file somewhere on the filesystem. When an affected
    class is called, this could result in the file being overwritten with
    the rights of the user running the script.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-5072


Solution: 
    All Mono users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/mono-1.1.13.8.1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-23] Mono: Insecure temporary file creation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Mono: Insecure temporary file creation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/mono", unaffected: make_list("ge 1.1.13.8.1"), vulnerable: make_list("lt 1.1.13.8.1")
)) { security_warning(0); exit(0); }
