# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200611-24.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23746);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200611-24");
 script_cve_id("CVE-2006-4335", "CVE-2006-4336", "CVE-2006-4337", "CVE-2006-4338");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200611-24
(LHa: Multiple vulnerabilities)


    Tavis Ormandy of the Google Security Team discovered several
    vulnerabilities in the LZH decompression component used by LHa. The
    make_table function of unlzh.c contains an array index error and a
    buffer overflow vulnerability. The build_tree function of unpack.c
    contains a buffer underflow vulnerability. Additionally, unlzh.c
    contains a code that could run in an infinite loop.
  
Impact

    By enticing a user to uncompress a specially crafted archive, a remote
    attacker could cause a Denial of Service by CPU consumption or execute
    arbitrary code with the rights of the user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-4335
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-4336
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-4337
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-4338


Solution: 
    All LHa users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-arch/lha-114i-r6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200611-24] LHa: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'LHa: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-arch/lha", unaffected: make_list("ge 114i-r6"), vulnerable: make_list("lt 114i-r6")
)) { security_warning(0); exit(0); }
