# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200612-10.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(23862);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200612-10");
 script_cve_id("CVE-2006-6097");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200612-10
(Tar: Directory traversal vulnerability)


    Tar does not properly extract archive elements using the GNUTYPE_NAMES
    record name, allowing files to be created at arbitrary locations using
    symlinks. Once a symlink is extracted, files after the symlink in the
    archive will be extracted to the destination of the symlink.
  
Impact

    An attacker could entice a user to extract a specially crafted tar
    archive, possibly allowing for the overwriting of arbitrary files on
    the system extracting the archive.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6097


Solution: 
    All Tar users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-arch/tar-1.16-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200612-10] Tar: Directory traversal vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Tar: Directory traversal vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-arch/tar", unaffected: make_list("ge 1.16-r2"), vulnerable: make_list("lt 1.16-r2")
)) { security_warning(0); exit(0); }
