# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-09.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24207);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-09");
 script_cve_id("CVE-2006-6767");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-09
(oftpd: Denial of Service)


    By specifying an unsupported address family in the arguments to a LPRT
    or LPASV command, an assertion in oftpd will cause the daemon to abort.
  
Impact

    Remote, unauthenticated attackers may be able to terminate any oftpd
    process, denying service to legitimate users.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-6767


Solution: 
    All oftpd users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-ftp/oftpd-0.3.7-r3"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-09] oftpd: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'oftpd: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-ftp/oftpd", unaffected: make_list("ge 0.3.7-r3"), vulnerable: make_list("lt 0.3.7-r3")
)) { security_warning(0); exit(0); }
