# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200701-19.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24255);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200701-19");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200701-19
(OpenLDAP: Insecure usage of /tmp during installation)


    Tavis Ormandy of the Gentoo Linux Security Team has discovered that the
    file gencert.sh distributed with the Gentoo ebuild for OpenLDAP does
    not exit upon the existence of a directory in /tmp during installation
    allowing for directory traversal.
  
Impact

    A local attacker could create a symbolic link in /tmp and potentially
    overwrite arbitrary system files upon a privileged user emerging
    OpenLDAP.
  
Workaround

    There is no known workaround at this time.
  

Solution: 
    All OpenLDAP users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "net-nds/openldap"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200701-19] OpenLDAP: Insecure usage of /tmp during installation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'OpenLDAP: Insecure usage of /tmp during installation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-nds/openldap", unaffected: make_list("ge 2.1.30-r10", "ge 2.2.28-r7", "ge 2.3.30-r2"), vulnerable: make_list("lt 2.1.30-r10", "lt 2.2.28-r7", "lt 2.3.30-r2")
)) { security_warning(0); exit(0); }
