# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24777);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-07");
 script_cve_id("CVE-2007-0803");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-07
(STLport: Possible remote execution of arbitrary code)


    Two buffer overflows have been discovered, one in "print floats" and
    one in the rope constructor.
  
Impact

    Both of the buffer overflows could result in the remote execution of
    arbitrary code. Please note that the exploitability of the
    vulnerabilities depends on how the library is used by other software
    programs.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0803


Solution: 
    All STLport users should upgrade to the latest version.
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-libs/STLport-5.0.3"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-07] STLport: Possible remote execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'STLport: Possible remote execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-libs/STLport", unaffected: make_list("ge 5.0.3"), vulnerable: make_list("lt 5.0.3")
)) { security_warning(0); exit(0); }
