# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200703-10.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(24802);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200703-10");
 script_cve_id("CVE-2007-0537", "CVE-2007-0478");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200703-10
(KHTML: Cross-site scripting (XSS) vulnerability)


    The KHTML code allows for the execution of JavaScript code located
    inside the "Title" HTML element, a related issue to the Safari error
    found by Jose Avila.
  
Impact

    When viewing a HTML page that renders unsanitized attacker-supplied
    input in the page title, Konqueror and other parts of KDE will execute
    arbitrary JavaScript code contained in the page title, allowing for the
    theft of browser session data or cookies.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0537
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-0478


Solution: 
    All KDElibs users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=kde-base/kdelibs-3.5.5-r8"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200703-10] KHTML: Cross-site scripting (XSS) vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'KHTML: Cross-site scripting (XSS) vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "kde-base/kdelibs", unaffected: make_list("ge 3.5.5-r8"), vulnerable: make_list("lt 3.5.5-r8")
)) { security_warning(0); exit(0); }
